texture TheTexture : register(t0);
sampler TheSampler : register(s0) = sampler_state
{
	Texture = <TheTexture>;
};

float4 PixelShaderFunction(in float2 texCoords : TEXCOORD0) : COLOR0
{
	float value = tex2D(TheSampler, texCoords).r;
	clip(value - 0.01);
	return float4(value, value, value, 1);
}

technique Technique1
{
    pass Pass1
    {
        PixelShader = compile ps_2_0 PixelShaderFunction();
    }
}
