texture TheTexture : register(t0);
sampler TheSampler : register(s0) = sampler_state
{
	Texture = <TheTexture>;
};

float MaxDepthValue;

void PixelShaderFunction(in float2 texCoords : TEXCOORD0, out float4 color : COLOR0, out float depth : DEPTH0)
{
	color = tex2D(TheSampler, texCoords);
	depth = min(color.r, MaxDepthValue);
}

technique Technique1
{
    pass Pass1
    {
        PixelShader = compile ps_2_0 PixelShaderFunction();
    }
}
